#include "socket-cpp/unix_address.h"
#include <cstring>
#include <stdexcept>

using namespace std;
using namespace osdev::components::socket-cpp;

constexpr sa_family_t unix_address::ADDRESS_FAMILY;
constexpr size_t unix_address::MAX_PATH_NAME;

// --------------------------------------------------------------------------

unix_address::unix_address(const string& path)
{
	addr_.sun_family = ADDRESS_FAMILY;
	::strncpy(addr_.sun_path, path.c_str(), MAX_PATH_NAME);
}

unix_address::unix_address(const sockaddr& addr)
{
    auto domain = addr.sa_family;
    if (domain != AF_UNIX)
        throw std::invalid_argument("Not a UNIX-domain address");

    // TODO: We should check the path, or at least see that it has
    // proper NUL termination.
    std::memcpy(&addr_, &addr, sizeof(sockaddr));
}

// --------------------------------------------------------------------------

ostream& operator<<(ostream& os, const unix_address& addr)
{
	os << "unix:" << addr.path();
	return os;
}

