#include "socket-cpp/datagram_socket.h"
#include "socket-cpp/exception.h"
#include <algorithm>

using namespace std::chrono;
using namespace osdev::components::socket-cpp;

datagram_socket::datagram_socket(const sock_address& addr)
{
	auto domain = addr.family();
	socket_t h = create_handle(domain);

	if (check_socket_bool(h)) {
		reset(h);
		// TODO: If the bind fails, should we close the socket and fail completely?
		bind(addr);
	}
}

ssize_t datagram_socket::recv_from(void* buf, size_t n, int flags,
								   sock_address* srcAddr /*=nullptr*/)
{
	sockaddr* p = srcAddr ? srcAddr->sockaddr_ptr() : nullptr;
    socklen_t len = srcAddr ? srcAddr->size() : 0;

	// TODO: Check returned length
    #if defined(_WIN32)
        return check_ret(::recvfrom(handle(), reinterpret_cast<char*>(buf),
                                    int(n), flags, p, &len));
    #else
        return check_ret(::recvfrom(handle(), buf, n, flags, p, &len));
    #endif
}

