#include "socket-cpp/connector.h"

using namespace osdev::components::socket-cpp;

bool connector::connect( const sock_address& addr )
{
    sa_family_t domain = addr.family();
	socket_t h = create_handle(domain);

	if (!check_ret_bool(h))
		return false;

	// This will close the old connection, if any.
	reset(h);

	if (!check_ret_bool(::connect(h, addr.sockaddr_ptr(), addr.size())))
		return close_on_err();

	return true;
}

