#pragma once

#include "socket-cpp/acceptor.h"
#include "socket-cpp/tcp6_socket.h"

namespace osdev {
namespace components {
namespace socket-cpp {

/// Class for creating a TCP v6 server.
/// Objects of this class bind and listen on TCP ports for incoming
/// connections. Normally, a server thread creates one of these and blocks
/// on the call to accept incoming connections. The call to accept creates
/// and returns a @ref tcp6_socket which can then be used for the actual
/// communications.

using tcp6_acceptor = acceptor_tmpl<tcp6_socket>;

}   // End namespace socket-cpp
}   // End namespace components
}   // End namespace osdev
