#include <iostream>
#include <string>
#include <chrono>
#include <thread>
#include "socket-cpp/can_socket.h"
#include "socket-cpp/can_frame.h"
#include "socket-cpp/version.h"

#include <net/if.h>
#include <sys/ioctl.h>

using namespace std;

// The clock to use to get time and pace the app.
using sysclock = chrono::system_clock;

// --------------------------------------------------------------------------

int main(int argc, char* argv[])
{
	cout << "Sample SocketCAN writer for 'Socket-Cpp' "
		<< osdev::components::socket-cpp::SOCKPP_VERSION << endl;

	string canIface = (argc > 1) ? argv[1] : "can0";
	canid_t canID = (argc > 2) ? atoi(argv[2]) : 0x20;

	osdev::components::socket-cpp::socket_initializer sockInit;

	osdev::components::socket-cpp::can_address addr(canIface);
	osdev::components::socket-cpp::can_socket sock(addr);

	if (!sock) {
		cerr << "Error binding to the CAN interface " << canIface << "\n\t"
			<< sock.last_error_str() << endl;
		return 1;
	}

	cout << "Created CAN socket on " << sock.address() << endl;
	time_t t = sysclock::to_time_t(sysclock::now());

	while (true) {
		// Sleep until the clock ticks to the next second
		this_thread::sleep_until(sysclock::from_time_t(t+1));

		// Re-read the time in case we fell behind
		t = sysclock::to_time_t(sysclock::now());

		// Write the time to the CAN bus as a 32-bit int
		auto nt = uint32_t(t);

		osdev::components::socket-cpp::can_frame frame { canID, &nt, sizeof(nt) };
		sock.send(frame);
	}

	return (!sock) ? 1 : 0;
}
