#include <iostream>
#include <iomanip>
#include <string>
#include <chrono>
#include <thread>
#include "socket-cpp/can_socket.h"
#include "socket-cpp/can_frame.h"
#include "socket-cpp/version.h"

#include <net/if.h>
#include <sys/ioctl.h>

using namespace std;

// The clock to use to get time and pace the app.
using sysclock = chrono::system_clock;

// --------------------------------------------------------------------------

int main(int argc, char* argv[])
{
	cout << "Sample SocketCAN writer for 'sockpp' "
		<< osdev::components::socket-cpp::SOCKPP_VERSION << endl;

	string canIface = (argc > 1) ? argv[1] : "can0";
	canid_t canID = (argc > 2) ? atoi(argv[2]) : 0x20;

	osdev::components::socket-cpp::socket_initializer sockInit;

	osdev::components::socket-cpp::can_address addr(canIface);
	osdev::components::socket-cpp::can_socket sock(addr);

	if (!sock) {
		cerr << "Error binding to the CAN interface " << canIface << "\n\t"
			<< sock.last_error_str() << endl;
		return 1;
	}

	cout << "Created CAN socket on " << sock.address() << endl;
	time_t t = sysclock::to_time_t(sysclock::now());

	cout.setf(ios::fixed, ios::floatfield);
	cout << setfill('0');

	while (true) {
		osdev::components::socket-cpp::can_frame frame;
		sock.recv(&frame);
		auto t = sock.last_frame_timestamp();

		cout << t << "  ";
		for (uint8_t i=0; i<frame.can_dlc; ++i)
			cout << hex << uppercase << setw(2) << unsigned(frame.data[i]) << " ";
		cout << endl;
	}

	return (!sock) ? 1 : 0;
}
