#include "SerialPort.hpp"

#include <iostream>
#include <string>
#include <vector>

int main(int argc, char** argv) 
{
    SerialPort oPort;
    
    oPort.SetDevice( "/dev/ttyUSB0" );
    oPort.SetNumDataBits(NumDataBits::EIGHT);
    oPort.SetParity(Parity::NONE);
    oPort.SetNumStopBits(NumStopBits::ONE);
    oPort.SetBaudRate( BaudRate::B_2400 );

    oPort.Open();
    
    // Create data package.
    std::vector<uint8_t> data_binair;
    std::string          data_string;
    
    for( uint8_t nCount = 0; nCount < 255; nCount++  )
    {
        data_binair.push_back( nCount );
        data_string += std::to_string(nCount);
    }
    while( 1 )
    {
        oPort.WriteBinary( data_binair );
        oPort.Write( data_string );
    }
    
    return 0;
}

