/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#ifndef QMQTT_WEBSOCKETIODEVICE_H
#define QMQTT_WEBSOCKETIODEVICE_H

#ifdef QT_WEBSOCKETS_LIB

#include <QByteArray>
#include <QIODevice>
#include <QList>
#include <QAbstractSocket>

QT_FORWARD_DECLARE_CLASS(QWebSocket)
QT_FORWARD_DECLARE_CLASS(QNetworkRequest)
QT_FORWARD_DECLARE_CLASS(QSslError)

namespace QMQTT
{

class WebSocketIODevice : public QIODevice
{
    Q_OBJECT
public:
    explicit WebSocketIODevice(QWebSocket *socket, QObject *parent = NULL);

    bool connectToHost(const QNetworkRequest &request);

    virtual qint64 bytesAvailable() const;

signals:
    void connected();

    void disconnected();

    void error(QAbstractSocket::SocketError error);

    void sslErrors(const QList<QSslError> &errors);

protected:
    virtual qint64 readData(char *data, qint64 maxSize);

    virtual qint64 writeData(const char *data, qint64 maxSize);

private slots:
    void binaryMessageReceived(const QByteArray &frame);

private:
    QByteArray _buffer;
    QWebSocket *_webSocket;
};

}

#endif // QT_WEBSOCKETS_LIB

#endif // QMQTT_WEBSOCKETIODEVICE_H
