/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#ifdef QT_WEBSOCKETS_LIB

#include "qmqtt_websocketiodevice_p.h"

#include <QWebSocket>

QMQTT::WebSocketIODevice::WebSocketIODevice(QWebSocket *socket, QObject *parent)
    : QIODevice(parent)
    , _webSocket(socket)
{
    connect(_webSocket, &QWebSocket::bytesWritten, this, &WebSocketIODevice::bytesWritten);
    connect(_webSocket, &QWebSocket::binaryMessageReceived,
            this, &WebSocketIODevice::binaryMessageReceived);
}

bool QMQTT::WebSocketIODevice::connectToHost(const QNetworkRequest &request)
{
    _webSocket->open(request);
    return QIODevice::open(QIODevice::ReadWrite);
}

qint64 QMQTT::WebSocketIODevice::bytesAvailable() const
{
    return _buffer.count();
}

void QMQTT::WebSocketIODevice::binaryMessageReceived(const QByteArray &frame)
{
    _buffer.append(frame);
    emit readyRead();
}

qint64 QMQTT::WebSocketIODevice::readData(char *data, qint64 maxSize)
{
    int size = qMin(static_cast<int>(maxSize), _buffer.count());
    for (int i=0; i<size; ++ i)
        data[i] = _buffer[i];
    _buffer.remove(0, size);
    return size;
}

qint64 QMQTT::WebSocketIODevice::writeData(const char *data, qint64 maxSize)
{
    QByteArray d(data, static_cast<int>(maxSize));
    return _webSocket->sendBinaryMessage(d);
}

#endif // QT_WEBSOCKETS_LIB
