/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#ifndef QMQTT_WEBSOCKET_H
#define QMQTT_WEBSOCKET_H

#ifdef QT_WEBSOCKETS_LIB

#include <qmqtt_socketinterface.h>
#include <qmqtt_websocketiodevice_p.h>

#include <QObject>
#include <QWebSocket>
#include <QHostAddress>
#include <QString>
#include <QList>
#include <QAbstractSocket>

QT_FORWARD_DECLARE_CLASS(QIODevice)

#ifndef QT_NO_SSL
#include <QSslConfiguration>
QT_FORWARD_DECLARE_CLASS(QSslError)
#endif // QT_NO_SSL

namespace QMQTT
{

class WebSocket : public SocketInterface
{
    Q_OBJECT
public:
#ifndef QT_NO_SSL
    WebSocket(const QString& origin,
              QWebSocketProtocol::Version version,
              const QSslConfiguration* sslConfig,
              QObject* parent = NULL);
#endif // QT_NO_SSL

    WebSocket(const QString& origin,
              QWebSocketProtocol::Version version,
              QObject* parent = NULL);

    virtual ~WebSocket();

    QIODevice *ioDevice()
    {
        return _ioDevice;
    }

    void connectToHost(const QHostAddress& address, quint16 port);
    void connectToHost(const QString& hostName, quint16 port);
    void disconnectFromHost();
    QAbstractSocket::SocketState state() const;
    QAbstractSocket::SocketError error() const;
#ifndef QT_NO_SSL
    void ignoreSslErrors(const QList<QSslError>& errors);
    void ignoreSslErrors();
    QSslConfiguration sslConfiguration() const;
    void setSslConfiguration(const QSslConfiguration& config);
#endif // QT_NO_SSL

private:
    void initialize();

    QWebSocket *_socket;
    WebSocketIODevice *_ioDevice;
};

}

#endif // QT_WEBSOCKETS_LIB

#endif // QMQTT_WEBSOCKET_H
