/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#ifndef QMQTT_TIMER_INTERFACE_H
#define QMQTT_TIMER_INTERFACE_H

#include "qmqtt_global.h"

#include <QObject>

namespace QMQTT {

class Q_MQTT_EXPORT TimerInterface : public QObject
{
    Q_OBJECT
public:
    explicit TimerInterface(QObject* parent = NULL) : QObject(parent) {}
    virtual ~TimerInterface() {}

    virtual bool isSingleShot() const = 0;
    virtual void setSingleShot(bool singleShot) = 0;
    virtual int interval() const = 0;
    virtual void setInterval(int msec) = 0;
    virtual void start() = 0;
    virtual void stop() = 0;

signals:
    void timeout();
};

}

#endif // QMQTT_TIMER_INTERFACE_H

