/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#ifndef QMQTT_SOCKET_INTERFACE_H
#define QMQTT_SOCKET_INTERFACE_H

#include "qmqtt_global.h"

#include <QObject>
#include <QHostAddress>
#include <QString>
#include <QAbstractSocket>
#include <QList>

#ifndef QT_NO_SSL
#include <QSslConfiguration>
QT_FORWARD_DECLARE_CLASS(QSslError)
#endif // QT_NO_SSL

QT_FORWARD_DECLARE_CLASS(QIODevice)

namespace QMQTT
{

class Q_MQTT_EXPORT SocketInterface : public QObject
{
    Q_OBJECT
public:
    explicit SocketInterface(QObject* parent = NULL) : QObject(parent) {}
    virtual ~SocketInterface() {}

    virtual QIODevice* ioDevice() = 0;
    virtual void connectToHost(const QHostAddress& address, quint16 port) = 0;
    virtual void connectToHost(const QString& hostName, quint16 port) = 0;
    virtual void disconnectFromHost() = 0;
    virtual QAbstractSocket::SocketState state() const = 0;
    virtual QAbstractSocket::SocketError error() const = 0;
#ifndef QT_NO_SSL
    virtual void ignoreSslErrors(const QList<QSslError>& errors) { Q_UNUSED(errors); }
    virtual void ignoreSslErrors() {}
    virtual QSslConfiguration sslConfiguration() const { return QSslConfiguration(); }
    virtual void setSslConfiguration(const QSslConfiguration& config) { Q_UNUSED(config); }
#endif // QT_NO_SSL

signals:
    void connected();
    void disconnected();
    void error(QAbstractSocket::SocketError socketError);
#ifndef QT_NO_SSL
    void sslErrors(const QList<QSslError>& errors);
#endif // QT_NO_SSL
};

}

#endif // QMQTT_SOCKET_INTERFACE_H
