/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#include "qmqtt_socket_p.h"

#include <QTcpSocket>

QMQTT::Socket::Socket(QObject* parent)
    : SocketInterface(parent)
    , _socket(new QTcpSocket(this))
{
    connect(_socket.data(), &QTcpSocket::connected,    this, &SocketInterface::connected);
    connect(_socket.data(), &QTcpSocket::disconnected, this, &SocketInterface::disconnected);
    connect(_socket.data(),
#if QT_VERSION >= QT_VERSION_CHECK(5, 15, 0)
            static_cast<void (QTcpSocket::*)(QAbstractSocket::SocketError)>(&QTcpSocket::errorOccurred),
#else
            static_cast<void (QTcpSocket::*)(QAbstractSocket::SocketError)>(&QTcpSocket::error),
#endif
            this,
            static_cast<void (SocketInterface::*)(QAbstractSocket::SocketError)>(&SocketInterface::error));
}

QMQTT::Socket::~Socket()
{
}

QIODevice *QMQTT::Socket::ioDevice()
{
    return _socket.data();
}

void QMQTT::Socket::connectToHost(const QHostAddress& address, quint16 port)
{
    _socket->connectToHost(address, port);
}

void QMQTT::Socket::connectToHost(const QString& hostName, quint16 port)
{
    _socket->connectToHost(hostName, port);
}

void QMQTT::Socket::disconnectFromHost()
{
    _socket->disconnectFromHost();
}

QAbstractSocket::SocketState QMQTT::Socket::state() const
{
    return _socket->state();
}

QAbstractSocket::SocketError QMQTT::Socket::error() const
{
    return _socket->error();
}
