/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#ifndef QMQTT_ROUTESUBSCRIPTION_H
#define QMQTT_ROUTESUBSCRIPTION_H

#include "qmqtt_global.h"

#include <QObject>
#include <QPointer>
#include <QString>
#include <QRegularExpression>
#include <QStringList>

namespace QMQTT {

class Client;
class Message;
class RoutedMessage;
class Router;

class Q_MQTT_EXPORT RouteSubscription : public QObject
{
    Q_OBJECT
public:
    ~RouteSubscription();

    QString route() const;

signals:
    void received(const RoutedMessage &message);

private slots:
    void routeMessage(const Message &message);

private:
    friend class Router;

    explicit RouteSubscription(Router *parent = 0);
    void setRoute(const QString &route);

    QPointer<Client> _client;
    QString _topic;
    QRegularExpression _regularExpression;
    QStringList _parameterNames;
};

} // namespace QMQTT

#endif // QMQTT_ROUTESUBSCRIPTION_H
