/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#include "qmqtt_router.h"
#include "qmqtt_client.h"
#include "qmqtt_routesubscription.h"

#include <QLoggingCategory>

namespace QMQTT {

Q_LOGGING_CATEGORY(router, "qmqtt.router")

Router::Router(Client *parent) : QObject(parent), _client(parent)
{
}

RouteSubscription *Router::subscribe(const QString &route)
{
    RouteSubscription *subscription = new RouteSubscription(this);
    subscription->setRoute(route);
    connect(_client, &Client::connected, subscription, [this, subscription]() {
        _client->subscribe(subscription->_topic, 0);
    });
    if (_client->isConnectedToHost())
        _client->subscribe(subscription->_topic, 0);
    connect(_client, &Client::received, subscription, &RouteSubscription::routeMessage);
    return subscription;
}

Client *Router::client() const
{
    return _client;
}

} // namespace QMQTT

