/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#ifndef QMQTT_ROUTEDMESSAGE_H
#define QMQTT_ROUTEDMESSAGE_H

#include "qmqtt_message.h"

#include <QMetaType>
#include <QHash>
#include <QString>

namespace QMQTT {

class RouteSubscription;

class Q_MQTT_EXPORT RoutedMessage
{
public:
    inline RoutedMessage()
    {}
    inline RoutedMessage(const Message &message)
        : _message(message)
    {}

    inline const Message &message() const
    { return _message; }
    inline QHash<QString, QString> parameters() const
    { return _parameters; }

private:
    friend class RouteSubscription;

    Message _message;
    QHash<QString, QString> _parameters;
};

} // namespace QMQTT

Q_DECLARE_METATYPE(QMQTT::RoutedMessage)

#endif // QMQTT_ROUTEDMESSAGE_H
