/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#ifndef OSDEV_COMPONENTS_PUBSUBCLIENT_H
#define OSDEV_COMPONENTS_PUBSUBCLIENT_H

// Qt
#include <QObject>
#include <QPair>
#include <QString>

// osdev::components
#include "qmqtt_client.h"
#include "qmqtt_states.h"
#include "qmqtt_message.h"
#include "qmqtt_configsettings.h"

namespace osdev {
namespace components {

class QMqttPubSubClient : public QMQTT::Client
{
    Q_OBJECT

public:
    explicit QMqttPubSubClient(const QHostAddress& host = QHostAddress::LocalHost,
                              const quint16 port = 1883,
                              QObject *parent = nullptr);

    virtual ~QMqttPubSubClient();

    void    subscribe(const QString& message_topic);
    void    unsubscribe(const QString& message_topic);
    void    publish(const QString& message_topic, const QString& message_payload);

    QString getErrorMessage( const QMQTT::ClientError error );

signals:
    void    signalMessageReceived(const QString& message_topic, const QString& message_payload);
    void    signalReInitialise();

private slots:
    // All status Slots
    void    slotOnConnected();
    void    slotOnDisconnected();
    void    slotOnError(const QMQTT::ClientError error);
    void    slotOnSubscribed(const QString& topic, const quint8 qos);
    void    slotOnUnSubscribed(const QString& topic);
    void    slotOnPublished(const QMQTT::Message& message, quint16 msgid);
    void    slotOnReceived(const QMQTT::Message& message);
    void    slotOnPingResp();
#ifndef QT_NO_SSL
    void    slotSslErrors(const QList<QSslError>& errors);
#endif  /* QT_NO_SSL */

private:
    void     connectSignalsAndSlots();

private:
    QString                 m_mqtt_topic;
    mqtt::E_CLIENT_STATE    m_current_state;
    QPair<QString, QString> m_subTemp;
    QPair<QString, QString> m_pubTemp;

};

}       /* End namespace components */
}       /* End namespace osdev  */

#endif  /* OSDEV_COMPONENTS_PUBSUBCLIENT_H */
