/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#ifndef QMQTT_NETWORK_INTERFACE_H
#define QMQTT_NETWORK_INTERFACE_H

#include "qmqtt_global.h"

#include <QObject>
#include <QAbstractSocket>
#include <QHostAddress>
#include <QString>
#include <QList>

#ifndef QT_NO_SSL
#include <QSslConfiguration>
QT_FORWARD_DECLARE_CLASS(QSslError)
#endif // QT_NO_SSL

namespace QMQTT {

class Frame;

class Q_MQTT_EXPORT NetworkInterface : public QObject
{
    Q_OBJECT
public:
    explicit NetworkInterface(QObject* parent = NULL) : QObject(parent) {}
    virtual ~NetworkInterface() {}

    virtual void sendFrame(const Frame& frame) = 0;
    virtual bool isConnectedToHost() const = 0;
    virtual bool autoReconnect() const = 0;
    virtual void setAutoReconnect(const bool autoReconnect) = 0;
    virtual int autoReconnectInterval() const = 0;
    virtual void setAutoReconnectInterval(const int autoReconnectInterval) = 0;
    virtual QAbstractSocket::SocketState state() const = 0;
#ifndef QT_NO_SSL
    virtual void ignoreSslErrors(const QList<QSslError>& errors) = 0;
    virtual QSslConfiguration sslConfiguration() const = 0;
    virtual void setSslConfiguration(const QSslConfiguration& config) = 0;
#endif // QT_NO_SSL

public slots:
    virtual void connectToHost(const QHostAddress& host, const quint16 port) = 0;
    virtual void connectToHost(const QString& hostName, const quint16 port) = 0;
    virtual void disconnectFromHost() = 0;
#ifndef QT_NO_SSL
    virtual void ignoreSslErrors() = 0;
#endif // QT_NO_SSL

signals:
    void connected();
    void disconnected();
    void received(const QMQTT::Frame& frame);
    void error(QAbstractSocket::SocketError error);
#ifndef QT_NO_SSL
    void sslErrors(const QList<QSslError>& errors);
#endif // QT_NO_SSL
};

} // namespace QMQTT

#endif // QMQTT_NETWORK_INTERFACE_H
