/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#ifndef QMQTT_MESSAGE_P_H
#define QMQTT_MESSAGE_P_H

#include <QSharedData>
#include <QString>
#include <QByteArray>

namespace QMQTT {

class MessagePrivate : public QSharedData
{
public:
    inline MessagePrivate()
        : QSharedData(),
          id(0),
          qos(0),
          retain(false),
          dup(false)
    {}

    inline MessagePrivate(const MessagePrivate &other)
        : QSharedData(other),
          id(other.id),
          qos(other.qos),
          retain(other.retain),
          dup(other.dup),
          topic(other.topic),
          payload(other.payload)
    {}

    inline MessagePrivate(quint16 id, const QString &topic, const QByteArray &payload,
                          quint8 qos, bool retain, bool dup)
        : QSharedData(),
          id(id),
          qos(qos),
          retain(retain),
          dup(dup),
          topic(topic),
          payload(payload)
    {}

    quint16 id;
    quint8 qos : 2;
    quint8 retain: 1;
    quint8 dup: 1;
    QString topic;
    QByteArray payload;
};

} // namespace QMQTT

#endif // QMQTT_MESSAGE_P_H
