/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#ifndef QMQTT_MESSAGE_H
#define QMQTT_MESSAGE_H

#include "qmqtt_global.h"

#include <QMetaType>
#include <QString>
#include <QByteArray>
#include <QSharedDataPointer>

namespace QMQTT {

class MessagePrivate;

class Q_MQTT_EXPORT Message
{
public:
    Message();
    explicit Message(const quint16 id, const QString &topic, const QByteArray &payload,
                     const quint8 qos = 0, const bool retain = false, const bool dup = false);
    Message(const Message &other);
    ~Message();

    Message &operator=(const Message &other);
#ifdef Q_COMPILER_RVALUE_REFS
    inline Message &operator=(Message &&other) Q_DECL_NOTHROW
    { swap(other); return *this; }
#endif

    bool operator==(const Message &other) const;
    inline bool operator!=(const Message &other) const
    { return !operator==(other); }

    inline void swap(Message &other) Q_DECL_NOTHROW
    { qSwap(d, other.d); }

    quint16 id() const;
    void setId(const quint16 id);

    quint8 qos() const;
    void setQos(const quint8 qos);

    bool retain() const;
    void setRetain(const bool retain);

    bool dup() const;
    void setDup(const bool dup);

    QString topic() const;
    void setTopic(const QString &topic);

    QByteArray payload() const;
    void setPayload(const QByteArray &payload);

private:
    QSharedDataPointer<MessagePrivate> d;
};

} // namespace QMQTT

Q_DECLARE_SHARED(QMQTT::Message)

Q_DECLARE_METATYPE(QMQTT::Message)

#endif // QMQTT_MESSAGE_H
