/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#include "qmqtt_message.h"
#include "qmqtt_message_p.h"

namespace QMQTT {

Message::Message()
    : d(new MessagePrivate)
{
}

Message::Message(const quint16 id, const QString &topic, const QByteArray &payload,
                 const quint8 qos, const bool retain, const bool dup)
    : d(new MessagePrivate(id, topic, payload, qos, retain, dup))
{
}

Message::Message(const Message &other)
    : d(other.d)
{
}

Message::~Message()
{
}

Message &Message::operator=(const Message &other)
{
    d = other.d;
    return *this;
}

bool Message::operator==(const Message &other) const
{
    if (d == other.d)
        return true;
    return d->id == other.d->id
            && d->qos == other.d->qos
            && d->retain == other.d->retain
            && d->dup == other.d->dup
            && d->topic == other.d->topic
            && d->payload == other.d->payload;
}

quint16 Message::id() const
{
    return d->id;
}

void Message::setId(const quint16 id)
{
    d->id = id;
}

quint8 Message::qos() const
{
    return d->qos;
}

void Message::setQos(const quint8 qos)
{
    d->qos = qos;
}

bool Message::retain() const
{
    return d->retain;
}

void Message::setRetain(const bool retain)
{
    d->retain = retain;
}

bool Message::dup() const
{
    return d->dup;
}

void Message::setDup(const bool dup)
{
    d->dup = dup;
}

QString Message::topic() const
{
    return d->topic;
}

void Message::setTopic(const QString &topic)
{
    d->topic = topic;
}

QByteArray Message::payload() const
{
    return d->payload;
}

void Message::setPayload(const QByteArray &payload)
{
    d->payload = payload;
}

} // namespace QMQTT
