/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#ifndef OSDEV_COMPONENTS_QMQTT_CONFIGSETTINGS_H
#define OSDEV_COMPONENTS_QMQTT_CONFIGSETTINGS_H

#include <QHostAddress>
#include <QHostInfo>
#include <QString>
#include <QByteArray>
#include <QUuid>

namespace osdev {
namespace components {

class QMqttConfigSettings
{
public:
    QMqttConfigSettings()
        : m_host_address( QHostAddress::LocalHost )
        , m_host_name( "localhost" )
        , m_host_port( 1883 )
        , m_client_id( QUuid::createUuid().toString() )
        , m_user_name( QString() )
        , m_password( QByteArray() )
        , m_keep_alive( 10 )
        , m_clean_session( false )
        , m_auto_reconnect( true )
        , m_auto_reconnect_interval( 60 )
    {}
    QMqttConfigSettings(const QHostAddress& host, const quint16 port )
        : m_host_address( host )
        , m_host_name( host.toString() )
        , m_host_port( port )
        , m_client_id( QUuid::createUuid().toString() )
        , m_user_name( QString() )
        , m_password( QByteArray() )
        , m_keep_alive( 10 )
        , m_clean_session( false )
        , m_auto_reconnect( true )
        , m_auto_reconnect_interval( 60 )
    {}

    virtual ~QMqttConfigSettings(){}

    // All Getters. Setters are handled in the implementation.
    void setHostAddress( const QHostAddress &host );
    QHostAddress getHostAddress() const;

    void setHostName( const QString& host_name );
    QString getHostName() const;

    void setPortNumber( const quint16 port );
    quint16 getPortNumber() const;

    void setClientId( const QString& clientId );
    QString getClientId() const;

    void    setUserName( const QString& user_name );
    QString getUserName() const;

    void setPassword( const QByteArray& pass_word );
    QByteArray getPassword() const;

    void setKeepAlive( const quint16 keep_alive );
    quint16 getKeepAlive() const;

    void setCleanSession( bool clean_session );
    bool getCleanSession() const;

    void setAutoReconnect( bool reconnect );
    bool getAutoReconnect() const;

    void setAutoReconnectInterval( const int auto_reconnect_interval );
    int getAutoReconnectInterval() const;

private:
    QHostAddress    m_host_address;
    QString         m_host_name;
    quint16         m_host_port;
    QString         m_client_id;
    QString         m_user_name;
    QByteArray      m_password;
    quint16         m_keep_alive;
    bool            m_clean_session;
    bool            m_auto_reconnect;
    int             m_auto_reconnect_interval;
};

}       /* End namespace components */
}       /* End namespace osdev */

#endif  /* OSDEV_COMPONENTS_QMQTT_CONFIGSETTINGS_H */
