/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#include "qmqtt_configsettings.h"
#include "log.h"

using namespace osdev::components;

void QMqttConfigSettings::setHostAddress( const QHostAddress &host )
{
    m_host_address = host;
}

QHostAddress QMqttConfigSettings::getHostAddress() const
{
    return m_host_address;
}

void QMqttConfigSettings::setHostName( const QString& host_name )
{
    m_host_name = host_name;
    QHostInfo host_info = QHostInfo::fromName( host_name );
    if( !host_info.addresses().isEmpty() )
    {
        m_host_address = host_info.addresses().first();
    }
    else
    {
        LogError( "[QMqttConfigSettings::setHostName]", QString( "Hostname : %1 failed to resolve to an ip-address." ).arg( host_name ) );
    }
}

QString QMqttConfigSettings::getHostName() const
{
    return m_host_name;
}

void QMqttConfigSettings::setPortNumber( const quint16 port )
{
    m_host_port = port;
}

quint16 QMqttConfigSettings::getPortNumber() const
{
    return m_host_port;
}

void QMqttConfigSettings::setClientId( const QString& clientId )
{
    m_client_id = clientId;
}

QString QMqttConfigSettings::getClientId() const
{
    return m_client_id;
}

void QMqttConfigSettings::setUserName( const QString& user_name )
{
    m_user_name = user_name;
}

QString QMqttConfigSettings::getUserName() const
{
    return m_user_name;
}

void QMqttConfigSettings::setPassword( const QByteArray& pass_word )
{
    m_password = pass_word;
}

QByteArray QMqttConfigSettings::getPassword() const
{
    return m_password;
}

void QMqttConfigSettings::setKeepAlive( const quint16 keep_alive )
{
    m_keep_alive = keep_alive;
}

quint16 QMqttConfigSettings::getKeepAlive() const
{
    return m_keep_alive;
}

void QMqttConfigSettings::setCleanSession( bool clean_session )
{
    m_clean_session = clean_session;
}

bool QMqttConfigSettings::getCleanSession() const
{
    return m_clean_session;
}

void QMqttConfigSettings::setAutoReconnect( bool reconnect )
{
    m_auto_reconnect = reconnect;
}

bool QMqttConfigSettings::getAutoReconnect() const
{
    return m_auto_reconnect;
}

void QMqttConfigSettings::setAutoReconnectInterval( const int auto_reconnect_interval )
{
    m_auto_reconnect_interval = auto_reconnect_interval;
}

int QMqttConfigSettings::getAutoReconnectInterval() const
{
    return m_auto_reconnect_interval;
}
