/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#ifndef OSDEV_COMPONENTS_QMQTT_H
#define OSDEV_COMPONENTS_QMQTT_H

#include <QObject>
#include <QString>
#include <QHash>
#include <QPointer>

#include "qmqtt_pubsubclient.h"
#include "qmqtt_configsettings.h"

namespace osdev {
namespace components {

class QMQTTClient : public QObject
{
    Q_OBJECT

public:
    QMQTTClient( const QMqttConfigSettings& connectionSettings = QMqttConfigSettings(), QObject *parent = nullptr );
    virtual ~QMQTTClient();

    void    subscribe( const QString& mqtt_topic );
    void    unsubscribe( const QString& mqtt_topic );
    void    publish( const QString& mqtt_topic, const QString& mqtt_message );

    int     getNumberOfConnections(){ return m_qhConnections.count(); }

signals:
    void    signalNewMessageReceived( const QString& mqtt_topic, const QString& mqtt_message );
    void    signalReInitialize();

private:
    bool    topicExists( const QString& topic );
    bool    createNewThread( const QString& topic );

private:    // Members (Giggity!)
    QHash<QString, QPointer<QMqttPubSubClient>> m_qhConnections;    ///< The container that keeps track of all connections by their topics.
    QMqttConfigSettings                         m_connConfig;       ///< All kinds of connection parameters in a convenient object.

};

}       /* End namespace components */
}       /* End namespace osdev  */

#endif  /* OSDEV_COMPONENTS_QMQTT_H */
