/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#ifndef OSDEV_COMPONENTS_BLUETOOTH_DEVICEINFO_H
#define OSDEV_COMPONENTS_BLUETOOTH_DEVICEINFO_H

#include <QString>
#include <QObject>
#include <QBluetoothDeviceInfo>

namespace osdev {
namespace components {
namespace bluetooth {

class DeviceInfo : public QObject
{
    Q_OBJECT

public:
    DeviceInfo( const QBluetoothDeviceInfo &device, QObject *parent = nullptr );

    void    setDevice( const QBluetoothDeviceInfo &device );

    QString getName() const;
    QString getAddress() const;
    QString getUuid() const;
    QBluetoothDeviceInfo getDevice() const;

signals:
    void    signalDeviceChanged();

private:
    QBluetoothDeviceInfo    m_device;
};

}       /* End namespace bluetooth  */
}       /* End namespace components */
}       /* End namespace osdev      */

#endif  /* OSDEV_COMPONENTS_BLUETOOTH_DEVICEINFO_H */
