/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#ifndef OSDEV_COMPONENTS_BLUETOOTH_DEVICEFINDER_H
#define OSDEV_COMPONENTS_BLUETOOTH_DEVICEFINDER_H

// osdev::components::bluetooh
#include "bluetoothbaseclass.h"
#include "deviceinfo.h"
#include "devicehandler.h"
//Qt
#include <QTimer>
#include <QVariant>
#include <QBluetoothDeviceDiscoveryAgent>
#include <QBluetoothDeviceInfo>

namespace osdev {
namespace components {
namespace bluetooth {

class DeviceFinder : public BluetoothBaseClass
{
    Q_OBJECT

public:
    DeviceFinder( DeviceHandler *handler, QObject *parent = nullptr );
    ~DeviceFinder();

    /// Deleted copy-constructor
    DeviceFinder( const DeviceFinder& ) = delete;
    /// Deleted assignment operator
    DeviceFinder& operator=(const DeviceFinder&) = delete;
    /// Deleted move-constructor
    DeviceFinder( DeviceFinder&& ) = delete;
    /// Deleted move operator
    DeviceFinder& operator=( DeviceFinder&& ) = delete;

    bool                scanning() const;
    QList<DeviceInfo*>  devices();
    QString             getAddressByName( const QString &name );

public slots:
    void                slotStartSearch();
    void                slotConnectToService( const QString &address );
    void                slotAddDevice( const QBluetoothDeviceInfo &device );
    void                slotScanError( QBluetoothDeviceDiscoveryAgent::Error error );
    void                slotScanFinished();
    void                slotDisconnect();

signals:
    void                signalScanningChanged();
    void                signalDevicesChanged();
    void                signalScanFinished();
    void                signalSendData( const QString &data );

private:
    DeviceHandler                   *m_pDeviceHandler;
    QBluetoothDeviceDiscoveryAgent  *m_pDeviceDiscoveryAgent;
    QList<DeviceInfo*>               m_devices;
};

}       /* End namespace bluetooth  */
}       /* End namespace components */
}       /* End namepsace osdev      */

#endif  /* OSDEV_COMPONENTS_BLUETOOTH_DEVICEFINDER_H */
