/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#ifndef OSDEV_COMPONENTS_BLUETOOTH_CONNECTIONHANDLER_H
#define OSDEV_COMPONENTS_BLUETOOTH_CONNECTIONHANDLER_H

// Qt
#include <QObject>
#include <QBluetoothLocalDevice>

namespace osdev {
namespace components {
namespace bluetooth {

class ConnectionHandler : public QObject
{
    Q_OBJECT

public:
    explicit ConnectionHandler( QObject *parent = nullptr );

    bool    alive() const;
    bool    requiresAddressType() const;
    QString name() const;
    QString address() const;

signals:
    void    signalDeviceChanged();

private slots:
    void    slotHostModeChanged( QBluetoothLocalDevice::HostMode mode );

private:
    QBluetoothLocalDevice   m_localDevice;
};

}       /* End namespace bluetooth  */
}       /* End namespace components */
}       /* End namespace osdev      */

#endif  /* OSDEV_COMPONENTS_BLUETOOTH_CONNECTIONHANDLER_H */
