/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
// Qt
#include <QDebug>

// osdev::components::bluetooth
#include "bluetoothbaseclass.h"

using namespace osdev::components::bluetooth;

BluetoothBaseClass::BluetoothBaseClass( QObject *parent )
    : QObject( parent )
    , m_error()
    , m_info()
{

}

QString BluetoothBaseClass::error() const
{
    return m_error;
}

void BluetoothBaseClass::setError( const QString &error )
{
    if( m_error != error )
    {
        m_error = error;
        qInfo() << m_error;
        emit signalErrorChanged();
    }
}

QString BluetoothBaseClass::info() const
{
    return m_info;
}

void BluetoothBaseClass::setInfo( const QString &info )
{
    if( m_info != info )
    {
        m_info = info;
        qInfo() << m_info;
        emit signalInfoChanged();
    }
}

void BluetoothBaseClass::clearMessages()
{
    setInfo( "" );
    setError( "" );
}
