#ifndef OSDEV_CAELUS_ORMTRANSQUEUE_H
#define OSDEV_CAELUS_ORMTRANSQUEUE_H

// Qt
#include <QObject>
#include <QTimer>
#include <QMutex>
#include <QMutexLocker>
#include <QQueue>

// Local
#include "ormreldata.h"

namespace osdev  {
namespace caelus {

class OrmTransQueue : public QObject
{
    Q_OBJECT

public:
    explicit OrmTransQueue( QObject *_parent = 0 );

    // Copy constructors.

    // Deleted copy- and move constructors
    OrmTransQueue( const OrmTransQueue& ) = delete;
    OrmTransQueue( const OrmTransQueue&& ) = delete;
    OrmTransQueue& operator=( const OrmTransQueue& ) = delete;
    OrmTransQueue& operator=( const OrmTransQueue&& ) = delete;

    // Timer control.
    /*!
     * \brief setTimeOut
     * \param msec
     */
    void    setTimeOut(int mseconds = 1 );

    // Queue control
    /*!
     * \brief   Inserts a ORMReldata objectpointer into the queue.
     * \param   pData - the (valid) pointer of the ORMRelData structure we want to queue for later processing
     * \return  True if transaction was saved to the queue successfully, false if not.
     */
    bool setTransaction( ORMRelData *pData );

    bool processing() const;

    void startProcessing( bool force = false );

    void stopProcessing( bool force = false );

    /*!
     * \brief   Returns the number of transactions stored in the queue.
     * \return  The number of transactions, or 0 if empty.
     */
    int  transactions_count() { return m_ormQueue.size(); }

signals:
    void signalProcessData( ORMRelData *pData );

private:
    QTimer              *m_pQueueTimer; ///< Timer controlling the processing of the queue.
    QMutex              *m_pQueueMutex; ///< Mutex to prevent race conditions.
    QQueue<ORMRelData*>  m_ormQueue;    ///< The actual FIFO taking a ORMRelData pointer as input.

private slots:
    /*!
     * \brief slotProcessQueue
     */
    void slotProcessQueue();


};

}   /* End namespace caelus */
}   /* End namespace osdev  */

#endif  /* OSDEV_CAELUS_ORMTRANSQUEUE_H */
