/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/

#ifndef OSDEV_COMPONENTS_MULTISORTFILTERPROXYMODEL_H
#define OSDEV_COMPONENTS_MULTISORTFILTERPROXYMODEL_H

#include <QObject>
#include <QMap>
#include <QSortFilterProxyModel>
#include <QString>

namespace osdev {
namespace components {

//! @brief Filter that can filter a model on multiple columns.
//! @note Do not mix uasge of setFilterKeyColumns and setFilterKeyColumn.
class MultiSortFilterProxyModel : public QSortFilterProxyModel
{
    Q_OBJECT

public:
    explicit MultiSortFilterProxyModel(QObject* parent = 0);

    //! @brief Set the columns to filter on.
    //! This will overwrite the previous filter settings (including the patterns).
    void setFilterKeyColumns(const QList<qint32>& filterColumns);

    //! @brief Add a pattern on a specific column index.
    //! If the index is not known the pattern is not applied.
    void setFilterFixedString(qint32 column, const QString& pattern);

protected:
    //! @brief Called from the base class to do the actual filtering.
    virtual bool filterAcceptsRow(int sourceRow, const QModelIndex& sourceParent) const;

private:
    QMap<qint32, QString> m_columnPatterns; ///< holds the filter pattern for column indices.
};

} // End namespace components
} // End namespace osdev

#endif // OSDEV_COMPONENTS_MULTISORTFILTERPROXYMODEL_H
