/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#include "multisortfilterproxymodel.h"

#include "log.h"

#include <QDebug>

using namespace osdev::components;

MultiSortFilterProxyModel::MultiSortFilterProxyModel(QObject* _parent)
    : QSortFilterProxyModel(_parent)
    , m_columnPatterns()
{
}

void MultiSortFilterProxyModel::setFilterKeyColumns(const QList<qint32> &filterColumns)
{
    m_columnPatterns.clear();
    foreach(qint32 column, filterColumns)
    {
        m_columnPatterns.insert(column, QString()); // Add columns with empty patterns
    }
}

void MultiSortFilterProxyModel::setFilterFixedString(qint32 column, const QString &pattern)
{
    if(!m_columnPatterns.contains(column))
    {
        return;
    }

    m_columnPatterns[column] = pattern;
}

bool MultiSortFilterProxyModel::filterAcceptsRow(int sourceRow, const QModelIndex &sourceParent) const
{
    if(m_columnPatterns.isEmpty())
    {
        return true; // No pattern -> accept all
    }

    for(QMap<qint32, QString>::const_iterator iter = m_columnPatterns.constBegin(); iter != m_columnPatterns.constEnd(); ++iter)
    {
        QModelIndex idx = sourceModel()->index(sourceRow, iter.key(), sourceParent);
        if (idx.data().toString() != iter.value())
        {
            return false;
        }
    }
    return true;
}
