/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/

#include "socketcontainer.h"

#include "tcpsocket.h"
#include "log.h"

namespace osdev  {
namespace components {

SocketContainer::SocketContainer()
    : m_hshFreeBySocket()
{
}

SocketContainer::~SocketContainer()
{
    // qDeleteAll( hshFreeBySocket.begin(), hshFreeBySocket.end() );
}

void SocketContainer::addSocket( TcpSocket *pSocket )
{
    if( pSocket )
    {
        // We store a channel in a ready state.
        m_hshFreeBySocket.insert( pSocket, true );
    }
}

void SocketContainer::removeSocket( TcpSocket *pSocket )
{
    if( pSocket )
    {
        // Remove the channel from the list.
        m_hshFreeBySocket.remove( pSocket );
    }
}

void SocketContainer::setChannelFree( TcpSocket *pSocket )
{
    if( pSocket )
    {
        auto socketIt = m_hshFreeBySocket.find(pSocket);
        if( m_hshFreeBySocket.end() != socketIt )
        {
            socketIt.value() = true;
        }
    }
}

void SocketContainer::setChannelBusy(TcpSocket *pSocket)
{
    if( pSocket )
    {
        auto socketIt = m_hshFreeBySocket.find(pSocket);
        if( m_hshFreeBySocket.end() != socketIt )
        {
            socketIt.value() = false;

            // printStatus();
        }
    }
}

TcpSocket* SocketContainer::getFreeSocket() const
{
    // printStatus();

    // Return a random socket with a free channel
    return m_hshFreeBySocket.key( true );
}

void SocketContainer::printStatus() const
{
    LogDebug("interfaceplugin", QString("getFreeSocket counts : ") + m_hshFreeBySocket.count());
    LogDebug("interfaceplugin", QString("==========================================================="));

    for(auto it = m_hshFreeBySocket.begin(); it != m_hshFreeBySocket.end(); ++it)
    {
        LogDebug("interfaceplugin", it.key()->objectName()+" : "+it.value());
    }
}

} // End namespace components
} // End namespace osdev 
