/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
//
// Description      :
// Revision         :
// Confidentiality  :
// Dependencies     :
//

#ifndef OSDEV_COMPONENTS_CMSGPARSER_H
#define OSDEV_COMPONENTS_CMSGPARSER_H

#include <QObject>
#include <QString>
#include <QUuid>

namespace osdev  {
namespace components {

/**
 * @brief The MsgParser class
 */
class MsgParser : public QObject
{
    Q_OBJECT

public:
    /**
     * @brief Constructor
     * @param _parent Parent QObject
     */
    MsgParser(QObject* _parent = nullptr);
    /// @brief Destructor
    ~MsgParser();

    /**
     * @brief Create a message with the given parameters
     * \param sourceID The source ID of the interface calling this function.
     * \param destID The destination ID of the interface receiving the data.
     * \param actionId The action to be performed on the data.
     * \param actionData The actual data (This must be XML formatted)
     */
    void createMsg(const QString& sourceID, const QString& destID,
                   int actionId, const QString& actionData);

    /**
     * @brief Retrieve the fields from the specified message
     * @param msg Message to parse
     */
    void parseMsg(const QString& msg);

    /// @return Message to parse
    QString getMsg() const;
    /// @return Source ID from the message
    QString getSourceId() const;
    /// @return Destination ID from the message
    QString getDestId() const;
    /// @return Action ID from the message
    int getActionId() const;
    /// @return Action data from the message
    QString getActionData() const;

//    void createMsg(const QString& sourceID, const QString& destID,
//                   int actionId, xercesc_2_7::DOMDocument* actionData);

private:
    QString m_message;      ///< Full message
    QString m_sourceId;     ///< Source ID in the message
    QString m_destId;       ///< Destination ID in the message
    int m_actionId;         ///< Action ID in the message
    QString m_actionData;   ///< Action Data in the message

    static const QString s_messageElementTag;
    static const QString s_sourceElementTag;
    static const QString s_destElementTag;
    static const QString s_actionElementTag;
    static const QString s_dataElementTag;
    static const QString s_idAttributeTag;
};

} // End namespace components
} // End namespace osdev 

#endif /* OSDEV_COMPONENTS_CMSGPARSER_H */
