/* ****************************************************************************
 * Copyright 2024 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/

#include "argumentparserbase.h"

ArgumentParserBase::ArgumentParserBase(int num_of_args, char* argv[])
{
    // Store the program name
    m_programName = argv[0];

    // Store the arguments
    for (int i = 1; i < num_of_args; i++)
    {
        std::string arg = argv[i];
        if (arg[0] == '-')
        {
            if (i + 1 < num_of_args)
            {
                m_arguments[arg] = argv[i + 1];
            }
            else
            {
                m_arguments[arg] = "";
            }
        }
    }
}

ArgumentParserBase::~ArgumentParserBase()
{
    m_arguments.clear();
    m_programName.clear();
}

std::string ArgumentParserBase::getArgument(const std::string &option)
{
    auto it = m_arguments.find(option);
    if (it != m_arguments.end())
    {
        return it->second;
    }
    return "";
}
