/* ****************************************************************************
 * Copyright 2024 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#include "argumentparser.h"

#include <iostream>

ArgumentParser::ArgumentParser(int num_of_args, char* argv[])
    : ArgumentParserBase(num_of_args, argv)
{
    if (count() == 0)
    {
        printUsage();
    }
}

std::string ArgumentParser::getHost()
{
    // -h | --host
    std::string host = getArgument("-h");
    if (host.empty())
    {
        host = getArgument("--host");
        if(host.empty())
        {
            host = "127.0.0.1";
        }
    }

    return host;
}

std::string ArgumentParser::getPort()
{
    // -p | --port
    std::string port = getArgument("-p");
    if (port.empty())
    {
        port = getArgument("--port");
        if(port.empty())
        {
            port = "1883";
        }
    }

    return port;
}

std::string ArgumentParser::getUserName()
{
    // -u | --username
    std::string username = getArgument("-u");
    if (username.empty())
    {
        username = getArgument("--username");
    }

    return username;
}

std::string ArgumentParser::getPassword()
{
    // -pw | --password
    std::string password = getArgument("-pw");
    if (password.empty())
    {
        password = getArgument("--password");
    }

    return password;
}

std::string ArgumentParser::getTopic()
{
    // -t | --topic
    std::string topic = getArgument("-t");
    if (topic.empty())
    {
        topic = getArgument("--topic");
    }

    return topic;
}

std::string ArgumentParser::getFile()
{
    // -f | --file
    std::string file = getArgument("-f");
    if (file.empty())
    {
        file = getArgument("--file");
    }

    return file;
}

std::string ArgumentParser::getMessage()
{
    // -m | --message
    std::string message = getArgument("-m");
    if (message.empty())
    {
        message = getArgument("--message");
    }

    return message;
}

void ArgumentParser::printUsage()
{
    std::cout << "Usage: " << getProgramName() << " [options]" << std::endl;
    std::cout << "Options:" << std::endl;
    std::cout << "  -h | --host <host>       Hostname or IP address of the MQTT broker. (Default 127.0.0.1)" << std::endl;
    std::cout << "  -p | --port <port>       Port number of the MQTT broker. (Default 1883)" << std::endl;
    std::cout << "  -u | --username <user>   Username for authentication" << std::endl;
    std::cout << "  -pw | --password <pass>  Password for authentication" << std::endl;
    std::cout << "  -t | --topic <topic>     Topic to publish the message to" << std::endl;
    std::cout << "  -f | --file <file>       File to publish" << std::endl;
    std::cout << "  -m | --message <message> Message to publish" << std::endl;
    std::cout << std::endl;
    std::cout << "Example(s): " << getProgramName() << " -h localhost -p 1883 -u user -pw password -t topic -f file.txt" << std::endl;
    std::cout << "            " << getProgramName() << " -h localhost -p 1883 -t topic -f file.txt" << std::endl;
    std::cout << "            " << getProgramName() << " -t topic -f file.txt" << std::endl;
    std::cout << std::endl;
}