/****************************************************************************
 * Copyright (c)2024 Open Systems Development B.V.
 ****************************************************************************/

#include "mqttclient.h"

#include <string>

using namespace osdev::components::mqtt;
using namespace osdev::components::log;

class Publisher
{
public:
    Publisher(const std::string &unique_id) : m_mqtt_client("SledgeHammerTest" + unique_id){}
    virtual ~Publisher() {}

    void connect( const std::string &hostname,
                  int portnumber = 1883,
                  const std::string &username = std::string(),
                  const std::string &password = std::string(),
                  const std::string &lwt_topic = std::string(),
                  const std::string &lwt_message = std::string()
                )
    {
        m_mqtt_client.connect(hostname, portnumber,
                              Credentials(username, password),
                              mqtt_LWT(lwt_topic, lwt_message),
                              true,
                              LogSettings
                              {
                                    LogLevel::Debug,
                                    LogMask::None
                              });
    }

    void disconnect()
    {
        m_mqtt_client.disconnect();
    }

    void publish(const std::string &message_topic, const std::string &message_payload)
    {
        MqttMessage message(message_topic, true, false, message_payload);
        Token t_result = m_mqtt_client.publish(message, 0);
    }

private:
    osdev::components::mqtt::MqttClient     m_mqtt_client;
};