/****************************************************************************
 * COpyright (c) 2023 Open Systems Development B.V.
 ****************************************************************************/

#include <gmock/gmock.h>
#include <gtest/gtest.h>
#include <string>
#include <memory>

#include "mqttclient.h"

using namespace osdev::components::mqtt;
using namespace osdev::components::log;

static const std::string main_topic = "Topic Length Test/";

/****************************************************************************
 *                      H E L P E R   C L A S S E S
 ****************************************************************************/
class Publisher
{
public:
    Publisher() : m_mqtt_client("TopicTester"){}
    virtual ~Publisher() {}

    void    connect(const std::string &hostname,
                 int portnumber = 1883,
                 const std::string &username = std::string(),
                 const std::string &password = std::string(),
                 const std::string &lwt_topic = std::string(),
                 const std::string &lwt_message = std::string()
                 )
    {
        m_mqtt_client.connect(hostname, portnumber,
                              osdev::components::mqtt::Credentials(username, password),
                              osdev::components::mqtt::mqtt_LWT(lwt_topic, lwt_message),
                              true,
                              osdev::components::log::LogSettings
                              {
                                  osdev::components::log::LogLevel::Debug,
                                  osdev::components::log::LogMask::None
                              });
    }

    void    publish(const std::string &message_topic, const std::string &message_payload)
    {
        osdev::components::mqtt::MqttMessage message(message_topic, true, false, message_payload);
        osdev::components::mqtt::Token t_result = m_mqtt_client.publish(message, 0);
    }

private:
    osdev::components::mqtt::MqttClient     m_mqtt_client;
};

/// @brief  class to generate a cumulative topic..
class TopicTester
{
    public:
        TopicTester(std::shared_ptr<Publisher> publisher) : m_publisher(publisher){}
        virtual ~TopicTester(){}

        void    RunTopicTester(int max_number_of_chars)
        {
            for(int nCount = 1; nCount < max_number_of_chars; nCount++)
            {
                std::string subtopic(nCount, 'a');
                std::string topic = std::string(main_topic + subtopic);
                std::string message(std::to_string(topic.size()) + " (" + std::to_string(subtopic.size()) + ")");

                m_publisher->publish(topic, message);
            }
        }

    private:
        std::shared_ptr<Publisher>  m_publisher;
};

/*****************************************************************************
 *                      T H E   A C T U A L   T E S T S
 *****************************************************************************/
/// TopicTester
TEST(topictest, TopicLengthTest)
{
    std::shared_ptr<Publisher> pPublisher = std::make_shared<Publisher>();
    pPublisher->connect("127.0.0.1", 1883);

    TopicTester oTester(pPublisher);

    oTester.RunTopicTester(101);
}
