/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#include "utils.h"

// std
#include <libgen.h>
#include <unistd.h>
#include <sstream>

#include <linux/limits.h>

using namespace osdev::components::mqtt;

std::string getPathToBinary(int pid)
{
    static const int sMaxPath = PATH_MAX;
    pid_t p = pid;
    if (-1 == pid)
    {
        p = getpid();
    }
    std::ostringstream oss;
    oss << "/proc/" << p << "/exe";
    char buf[sMaxPath] = { 0 };
    ssize_t r = readlink(oss.str().c_str(), buf, sMaxPath);
    if (-1 == r)
    {
        // "readlink failed"
    }
    if (r >= sMaxPath)
    {
        buf[sMaxPath - 1] = '\0'; // make the buffer 0 terminated
        // "path is too long"
    }
    return dirname(buf);
}
