/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#include "token.h"

using namespace osdev::components::mqtt;

Token::Token()
    : m_clientId( "" )
    , m_token( -1 )
{}

Token::Token( const std::string &_clientId, std::int32_t _tokenNr )
    : m_clientId( _clientId )
    , m_token( _tokenNr )
{}

bool Token::equals( const Token &rhs ) const
{
    return ( rhs.m_clientId == m_clientId && rhs.m_token == m_token);
}

bool Token::smallerThan( const Token &rhs ) const
{
    if( m_clientId < rhs.m_clientId )
    {
        return true;
    }
    else if( rhs.m_clientId < m_clientId )
    {
        return false;
    }

    return m_token < rhs.m_token;
}

namespace osdev {
namespace components {
namespace mqtt {

std::ostream& operator<<(std::ostream &os, const Token &rhs )
{
    return os << rhs.clientId() << '-' << rhs.token();
}

}       // End namespace mqtt
}       // End namespace components
}       // End namespace osdev
