/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#include "timemeasurement.h"

using namespace osdev::components::mqtt::measurement;

TimeMeasurement::TimeMeasurement(const std::string& id, const TimeMeasurementCallback& cb, bool measureOnDestruction)
    : m_id(id)
    , m_start(std::chrono::steady_clock::now())
    , m_last(m_start)
    , m_callback(cb)
    , m_measureOnDestruction(measureOnDestruction)
{
}

TimeMeasurement::~TimeMeasurement()
{
    if (m_measureOnDestruction) {
        this->measure();
    }
}

void TimeMeasurement::set()
{
    m_last = std::chrono::steady_clock::now();
}

void TimeMeasurement::measure()
{
    auto now = std::chrono::steady_clock::now();
    auto sinceLast = std::chrono::duration_cast<std::chrono::microseconds>(now - m_last);
    auto sinceStart = std::chrono::duration_cast<std::chrono::microseconds>(now - m_start);
    m_last = now;

    m_callback(m_id, m_start, sinceStart, sinceLast);
}
