/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#include "mqttsuccess.h"

using namespace osdev::components::mqtt;

ConnectionData::ConnectionData()
    : m_serverUri()
    , m_mqttVersion()
    , m_sessionPresent()
{
}

ConnectionData::ConnectionData(char* _serverUri, int _mqttVersion, int _sessionPresent)
    : m_serverUri(_serverUri ? _serverUri : "unknown")
    , m_mqttVersion(_mqttVersion)
    , m_sessionPresent(0 != _sessionPresent)
{
}

MqttSuccess::MqttSuccess(MQTTAsync_token _token)
    : m_token(_token)
    , m_data(Unspecified{})
{
}

MqttSuccess::MqttSuccess(MQTTAsync_token _token, int _qos)
    : m_token(_token)
    , m_data(_qos)
{
}

MqttSuccess::MqttSuccess(MQTTAsync_token _token, const std::vector<int>& _qosMany)
    : m_token(_token)
    , m_data(_qosMany)
{
}

MqttSuccess::MqttSuccess(MQTTAsync_token _token, const MqttMessage& pubMsg)
    : m_token(_token)
    , m_data(pubMsg)
{
}

MqttSuccess::MqttSuccess(MQTTAsync_token _token, const ConnectionData& connData)
    : m_token(_token)
    , m_data(connData)
{
}

int MqttSuccess::qos() const
{
    return boost::get<int>(m_data);
}

std::vector<int> MqttSuccess::qosMany() const
{
    return boost::get<std::vector<int>>(m_data);
}

MqttMessage MqttSuccess::publishData() const
{
    return boost::get<MqttMessage>(m_data);
}

ConnectionData MqttSuccess::connectionData() const
{
    return boost::get<ConnectionData>(m_data);
}
