/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#include "mqttmessage.h"

using namespace osdev::components::mqtt;

MqttMessage::MqttMessage()
    : m_retained()
    , m_duplicate()
    , m_topic()
    , m_payload()
{}

MqttMessage::MqttMessage(const std::string &_topic, const MQTTAsync_message &message)
    : m_retained( 0 != message.retained )
    , m_duplicate( 0 != message.dup )
    , m_topic( _topic )
    , m_payload()
{
    const char *msg = reinterpret_cast<const char*>(message.payload);
    m_payload = std::string( msg, msg + message.payloadlen );
}

MqttMessage::MqttMessage( const std::string &_topic, bool retainedFlag, bool duplicateFlag, std::string thePayload )
    : m_retained( retainedFlag )
    , m_duplicate( duplicateFlag )
    , m_topic( _topic )
    , m_payload( thePayload )
{}

MQTTAsync_message MqttMessage::toAsyncMessage() const
{
    MQTTAsync_message msg = MQTTAsync_message_initializer;
    msg.payload = reinterpret_cast<void*>( const_cast<char*>( m_payload.c_str() ) );
    msg.payloadlen = static_cast<int>( m_payload.size() );
    msg.qos = -1;
    msg.retained = static_cast<int>( m_retained );

    return msg;
}
