/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#include "mqttfailure.h"

// osdev::components::mqtt
#include "errorcode.h"

using namespace osdev::components::mqtt;

MqttFailure::MqttFailure(const MQTTAsync_failureData* data)
    : m_token(data ? data->token : 0)
    , m_code(data ? data->code : MQTTASYNC_FAILURE)
    , m_message()
{
    if (!data) {
        m_message = "missing response data";
    }
    else if (!data->message) {
        m_message = "no message";
    }
    else {
        m_message = std::string(data->message);
    }
}

std::string MqttFailure::codeToString() const
{
    if (m_code < 0) {
        return pahoAsyncErrorCodeToString(m_code);
    }
    else if (0x80 == m_code) {
        return "Failure";
    }
    return std::string("Unknown(") + std::to_string(m_code) + ")";
}
