/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#include "istatecallback.h"

#include <sstream>

namespace osdev {
namespace components {
namespace mqtt {

std::ostream& operator<<(std::ostream& os, StateEnum rhs)
{
    switch (rhs) {
        case StateEnum::Unknown:
            os << "Unknown";
            break;
        case StateEnum::CommunicationFailure:
            os << "CommunicationFailure";
            break;
        case StateEnum::GeneralFailure:
            os << "GeneralFailure";
            break;
        case StateEnum::Good:
            os << "Good";
            break;
        case StateEnum::Shutdown:
            os << "Shutdown";
            break;
        case StateEnum::ConnectionFailure:
            os << "ConnectionFailure";
            break;
        case StateEnum::Unregister:
            os << "Unregister";
            break;
    }
    return os;
}

std::string createIdentifier(const std::string& idStatic, const ClientIdentifier& clientId, const IStateCallback* idDynamic)
{
    std::ostringstream oss;
    oss << idStatic;
    if (!clientId.m_id.empty()) {
        oss << "::" << clientId.m_id;
    }
    oss << " " << idDynamic;
    return oss.str();
}

IStateCallback::~IStateCallback()
{
}

}   // End namespace mqtt
}   // End namespace components
}   // End namespace osdev
