/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#include "errorcode.h"

// paho
#include <MQTTAsync.h>

namespace osdev {
namespace components {
namespace mqtt {

std::string pahoAsyncErrorCodeToString( int errorCode )
{
    if (MQTTASYNC_SUCCESS == errorCode) {
        return "MQTTASYNC_SUCCESS";
    }
    else if (MQTTASYNC_FAILURE == errorCode) {
        return "MQTTASYNC_FAILURE";
    }
    else if (MQTTASYNC_PERSISTENCE_ERROR == errorCode) {
        return "MQTTASYNC_PERSISTENCE_ERROR";
    }
    else if (MQTTASYNC_DISCONNECTED == errorCode) {
        return "MQTTASYNC_DISCONNECTED";
    }
    else if (MQTTASYNC_MAX_MESSAGES_INFLIGHT == errorCode) {
        return "MQTTASYNC_MAX_MESSAGES_INFLIGHT";
    }
    else if (MQTTASYNC_BAD_UTF8_STRING == errorCode) {
        return "MQTTASYNC_BAD_UTF8_STRING";
    }
    else if (MQTTASYNC_NULL_PARAMETER == errorCode) {
        return "MQTTASYNC_NULL_PARAMETER";
    }
    else if (MQTTASYNC_TOPICNAME_TRUNCATED == errorCode) {
        return "MQTTASYNC_TOPICNAME_TRUNCATED";
    }
    else if (MQTTASYNC_BAD_STRUCTURE == errorCode) {
        return "MQTTASYNC_BAD_STRUCTURE";
    }
    else if (MQTTASYNC_BAD_QOS == errorCode) {
        return "MQTTASYNC_BAD_QOS";
    }
    else if (MQTTASYNC_NO_MORE_MSGIDS == errorCode) {
        return "MQTTASYNC_NO_MORE_MSGIDS";
    }
    else if (MQTTASYNC_OPERATION_INCOMPLETE == errorCode) {
        return "MQTTASYNC_OPERATION_INCOMPLETE";
    }
    else if (MQTTASYNC_MAX_BUFFERED_MESSAGES == errorCode) {
        return "MQTTASYNC_MAX_BUFFERED_MESSAGES";
    }
    else if (MQTTASYNC_SSL_NOT_SUPPORTED == errorCode) {
        return "MQTTASYNC_SSL_NOT_SUPPORTED";
    }
    else if (MQTTASYNC_BAD_PROTOCOL == errorCode) {
        return "MQTTASYNC_BAD_PROTOCOL";
    }
#if defined MQTTASYNC_BAD_MQTT_OPTION               // Not supported by centos7 paho-c
    else if (MQTTASYNC_BAD_MQTT_OPTION == errorCode) {
        return "MQTTASYNC_BAD_MQTT_OPTION";
    }
#endif
#if defined MQTTASYNC_WRONG_MQTT_VERSION            // Not supported by centos7 paho-c
    else if (MQTTASYNC_WRONG_MQTT_VERSION == errorCode) {
        return "MQTTASYNC_WRONG_MQTT_VERSION";
    }
#endif
    return "Unknown(" + std::to_string(errorCode) + ")";
}

}       // End namespace mqtt
}       // End namespace components
}       // End namespace osdev
