/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#include "commondefs.h"

// std
#include <ctime>
#include <iomanip>

namespace osdev {
namespace components {
namespace mqtt {

std::ostream& operator<<(std::ostream& os, const StdTimeMs& rhs)
{
    const std::time_t rhsTimeT = std::chrono::system_clock::to_time_t(rhs);
    struct tm tms
    {
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, nullptr
    };
    if (nullptr == gmtime_r(&rhsTimeT, &tms)) {
        os << "unknown";
    }
    else {
        char str[26] = { 0 };
        if (std::strftime(str, sizeof(str), "%Y-%m-%d %H:%M:%S.", &tms) > 0) {
            std::ostringstream oss;
            oss << str << std::setfill('0') << std::setw(3) << std::chrono::duration_cast<std::chrono::milliseconds>(rhs.timePoint - std::chrono::system_clock::from_time_t(rhsTimeT)).count() << ' ';
            if (std::strftime(str, sizeof(str), "%z", &tms) == 0) {
                return os;
            }
            oss << str;
            os << oss.str();
        }
    }
    return os;
}

}       // End namespace mqtt
}       // End namespace components
}       // End namespace osdev

namespace std {

std::ostream& operator<<(std::ostream& os, const osdev::components::mqtt::StdTime& rhs)
{
    /// @todo: Use put_time when it's implemented in gcc (5.0)
    //    auto rhsTimeT = std::chrono::system_clock::to_time_t(rhs);
    //    os << std::put_time(std::localtime(&rhsTimeT), "%F %T");
    const std::time_t rhsTimeT = std::chrono::system_clock::to_time_t(rhs);
    struct tm tms
    {
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, nullptr
    };
    if (nullptr == gmtime_r(&rhsTimeT, &tms)) {
        os << "unknown";
    }
    else {
        char str[26];
        if (std::strftime(str, sizeof(str), "%Y-%m-%d %H:%M:%S %z", &tms) > 0) {
            os << str;
        }
    }
    return os;
}

}       // End namespace std
