/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#ifndef OSDEV_COMPONENTS_MQTT_URIUTILS_H
#define OSDEV_COMPONENTS_MQTT_URIUTILS_H

// std
#include <string>

#include "compiletimedigits.h"

namespace osdev {
namespace components {
namespace mqtt {

/**
 * @brief Get the percent encoded string for a given character.
 * @tparam N The character to encode.
 * @return pointer to the encoded character string.
 */
template <unsigned N>
inline const char* percentEncode()
{
    static const auto* s_code =
        (compiletime_string<'%'>{} + typename apply_bounded_range<     //
                                         0,                            //
                                         numberOfDigits<16>(N),        //
                                         string_builder<               //
                                             adapt_for_string_builder< //
                                                 ProduceDigits<N, 16>>>::template produce>::result{})
            .chars;
    return s_code;
}

}       // End namespace mqtt
}       // End namespace components
}       // End namespace osdev

#endif  // OSDEV_COMPONENTS_MQTT_URIUTILS_H
