/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#ifndef OSDEV_COMPONENTS_MQTT_MEASUREMENT_TIMEMEASUREMENT_H
#define OSDEV_COMPONENTS_MQTT_MEASUREMENT_TIMEMEASUREMENT_H

#include <chrono>
#include <functional>
#include <ostream>
#include <string>

namespace osdev {
namespace components {
namespace mqtt {
namespace measurement {

using TimeMeasurementCallback = std::function<void(const std::string& id, std::chrono::steady_clock::time_point start, std::chrono::microseconds sinceStart, std::chrono::microseconds sinceLast)>;

class TimeMeasurement
{
public:
    TimeMeasurement(const std::string& id, const TimeMeasurementCallback& callback, bool measureOnDestruction = true);
    ~TimeMeasurement();

    TimeMeasurement(const TimeMeasurement&) = delete;
    TimeMeasurement& operator=(const TimeMeasurement&) = delete;
    TimeMeasurement(TimeMeasurement&&) = default;
    TimeMeasurement& operator=(TimeMeasurement&&) = default;

    void set();
    void measure();

private:
    std::string m_id;

    std::chrono::steady_clock::time_point m_start;
    std::chrono::steady_clock::time_point m_last;
    TimeMeasurementCallback m_callback;
    bool m_measureOnDestruction;
};

template <typename Rep, typename Dur>
std::ostream& operator<<(std::ostream& os, const std::chrono::duration<Rep, Dur>& rhs)
{
    os << rhs.count();
    return os;
}

}       // End namespace measurement
}       // End namespace mqtt
}       // End namespace components
}       // End namespace osdev

#endif  // OSDEV_COMPONENTS_MQTT_MEASUREMENT_TIMEMEASUREMENT_H
