/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#ifndef OSDEV_COMPONENTS_MQTT_STRINGUTILS_H
#define OSDEV_COMPONENTS_MQTT_STRINGUTILS_H

// See boost/algorithm/string.hpp for more string utility functions

// std
#include <sstream>
#include <string>
#include <vector>

namespace osdev {
namespace components {
namespace mqtt {

/**
 * @brief Removes characters from the specified string. Modifies the specified string in place.
 * @param str The string to modify.
 * @param charsToRemove The characters to remove from str.
 */
void removeCharsFromStringInPlace(std::string& str, const std::string& charsToRemove);

/**
 * @brief Determines whether the specified string is all digits.
 * @param str The string for which to determine if it's numeric.
 * @return True if the specified string is numeric; otherwise, false.
 */
bool is_numeric(const std::string& str);

}       // End namespace mqtt
}       // End namespace components
}       // End namespace osdev

#endif  // OSDEV_COMPONENTS_MQTT_STRINGUTILS_H
