/* ****************************************************************************
 * Copyright 2019 Open Systems Development BV                                 *
 *                                                                            *
 * Permission is hereby granted, free of charge, to any person obtaining a    *
 * copy of this software and associated documentation files (the "Software"), *
 * to deal in the Software without restriction, including without limitation  *
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,   *
 * and/or sell copies of the Software, and to permit persons to whom the      *
 * Software is furnished to do so, subject to the following conditions:       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    *
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    *
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        *
 * DEALINGS IN THE SOFTWARE.                                                  *
 * ***************************************************************************/
#ifndef OSDEV_COMPONENTS_MQTT_MQTTUTIL_H
#define OSDEV_COMPONENTS_MQTT_MQTTUTIL_H

// std
#include <string>

namespace osdev {
namespace components {
namespace mqtt {

/*!
 *  \brief  Determine if topic is a valid mqtt topic filter.
 *  \param  topic    - The topic to test.
 *  \return True when topic is valid, false otherwise.
 */
bool isValidTopic( const std::string &topic );

/*!
 *  \brief  Test a topic against another topicfilter for overlap.
 *  \param  existingTopic   - The topic to test against
 *  \param  newTopic        - The topic to test.
 *  \return True when topics overlap, false otherwise
 */
bool testForOverlap( const std::string & existingTopic, const std::string &newTopic );

/*!
 *  \brief  Test a topic for occurence of wildcards
 *  \param  topic   - The topic to test
 *  \return True if topics contains wildcards, false otherwise
 */
bool hasWildcard( const std::string &topic );

/*!
 *  \brief  Create a regular expression string based on a topicfilter that can be used
 *          to match topic strings against topics with no wildcards.
 *  \pre    The topic filter is valid.
 *  \return The regular expression string. If the topic filter is not valid then the
 *          returned string is also not valid.
 */
std::string convertTopicToRegex( const std::string &topic );

}       // End namespace mqtt
}       // End namespace components
}       // osdev

#endif  // OSDEV_COMPONENTS_MQTT_MQTTUTIL_H
